# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-icecat-view-2 =
  .label = { -icecatview-brand-name }
  .tooltiptext = View recent browsing across windows and devices

menu-tools-icecat-view =
  .label = { -icecatview-brand-name }
  .accesskey = F

icecatview-page-title = { -icecatview-brand-name }

icecatview-page-heading =
  .heading = { -icecatview-brand-name }

icecatview-page-label =
  .label = { -icecatview-brand-name }

# Used instead of the localized relative time when a timestamp is within a minute or so of now
icecatview-just-now-timestamp = Just now

icecatview-syncedtabs-signin-header-2 = Your { -brand-product-name } on all your devices
icecatview-syncedtabs-signin-description-2 = To see tabs you have open on your phone and other devices, sign in or sign up for an account. With an account, you can also sync your passwords, history, and more.
icecatview-syncedtabs-signin-primarybutton-2 = Sign in

icecatview-syncedtabs-adddevice-header-2 = Grab tabs from anywhere
icecatview-syncedtabs-adddevice-description-2 = Sign in to { -brand-product-name } on your phone or another computer to see tabs here. Learn how to <a data-l10n-name="url">connect additional devices</a>.
icecatview-syncedtabs-adddevice-primarybutton = Try { -brand-product-name } for mobile

icecatview-tabpickup-synctabs-primarybutton = Sync open tabs

icecatview-syncedtabs-synctabs-header = Update your sync settings
icecatview-syncedtabs-synctabs-description = To see tabs from other devices, you need to sync your open tabs.

icecatview-syncedtabs-loading-header = Sync in progress
icecatview-syncedtabs-loading-description = When it’s done, you’ll see any tabs you have open on other devices. Check back soon.

icecatview-tabpickup-fxa-admin-disabled-header = Your organization has disabled sync
icecatview-tabpickup-fxa-disabled-by-policy-description = { -brand-short-name } is not able to sync tabs between devices because your organization has disabled syncing.

icecatview-tabpickup-network-offline-header = Check your internet connection
icecatview-tabpickup-network-offline-description = If you’re using a firewall or proxy, check that { -brand-short-name } has permission to access the web.
icecatview-tabpickup-network-offline-primarybutton = Try again

icecatview-tabpickup-sync-error-header = We’re having trouble syncing
icecatview-tabpickup-generic-sync-error-description = { -brand-short-name } can’t reach the syncing service right now. Try again in a few moments.
icecatview-tabpickup-sync-error-primarybutton = Try again

icecatview-tabpickup-sync-disconnected-header = Turn on syncing to continue
icecatview-tabpickup-sync-disconnected-description = To grab your tabs, you’ll need to allow syncing in { -brand-short-name }.
icecatview-tabpickup-sync-disconnected-primarybutton = Turn on sync in settings

icecatview-tabpickup-password-locked-header = Enter your Primary Password to view tabs
icecatview-tabpickup-password-locked-description = To grab your tabs, you’ll need to enter the Primary Password for { -brand-short-name }.
icecatview-tabpickup-password-locked-link = Learn more
icecatview-tabpickup-password-locked-primarybutton = Enter Primary Password
icecatview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">Learn more</a>

icecatview-tabpickup-signed-out-header = Sign in to reconnect
icecatview-tabpickup-signed-out-description2 = To reconnect and grab your tabs, sign in to your account.
icecatview-tabpickup-signed-out-primarybutton = Sign in

# Variables:
#   $tabTitle (string) - Title of tab being dismissed
icecatview-closed-tabs-dismiss-tab =
  .title = Dismiss { $tabTitle }

# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
icecatview-tabs-list-tab-button =
  .title = Open { $targetURI } in a new tab

icecatview-collapse-button-show =
  .title = Show list

icecatview-collapse-button-hide =
  .title = Hide list

icecatview-overview-nav = Recent browsing
  .title = Recent browsing
icecatview-overview-header = Recent browsing
  .title = Recent browsing

## History in this context refers to browser history

icecatview-history-nav = History
  .title = History
icecatview-history-header = History
icecatview-history-context-delete = Delete from History
    .accesskey = D

## Open Tabs in this context refers to all open tabs in the browser

icecatview-opentabs-nav = Open tabs
  .title = Open tabs
icecatview-opentabs-header = Open tabs

## Recently closed tabs in this context refers to recently closed tabs from all windows

icecatview-recently-closed-nav = Recently closed tabs
  .title = Recently closed tabs
icecatview-recently-closed-header = Recently closed tabs

## Tabs from other devices refers in this context refers to synced tabs from other devices

icecatview-synced-tabs-nav = Tabs from other devices
  .title = Tabs from other devices
icecatview-synced-tabs-header = Tabs from other devices

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of IceCat View
icecatview-view-all-link = View all

# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
icecatview-opentabs-window-header =
  .title = Window { $winID }

# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
icecatview-opentabs-current-window-header =
  .title = Window { $winID } (Current)

icecatview-show-more = Show more
icecatview-show-less = Show less
icecatview-show-all = Show all

icecatview-search-text-box-clear-button =
  .title = Clear

# Placeholder for the input field to search in recent browsing ("search" is a verb).
icecatview-search-text-box-recentbrowsing =
  .placeholder = Search

# Placeholder for the input field to search in history ("search" is a verb).
icecatview-search-text-box-history =
  .placeholder = Search history

# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
icecatview-search-text-box-recentlyclosed =
  .placeholder = Search recently closed tabs

# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
icecatview-search-text-box-tabs =
  .placeholder = Search tabs

# Placeholder for the input field to search in open tabs ("search" is a verb).
icecatview-search-text-box-opentabs =
  .placeholder = Search open tabs

# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
icecatview-search-results-header = Search results for “{ $query }”

# Variables:
#   $count (Number) - The number of visits matching the search query.
icecatview-search-results-count = { $count ->
  [one] { $count } site
 *[other] { $count } sites
}

# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
icecatview-search-results-empty = No results for “{ $query }”

icecatview-sort-history-by-date-label = Sort by date
icecatview-sort-history-by-site-label = Sort by site
icecatview-sort-open-tabs-by-recency-label = Sort by recent activity
icecatview-sort-open-tabs-by-order-label = Sort by tab order

## Variables:
##   $date (string) - Date to be formatted based on locale

icecatview-history-date-today = Today - { DATETIME($date, dateStyle: "full") }
icecatview-history-date-yesterday = Yesterday - { DATETIME($date, dateStyle: "full") }
icecatview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
icecatview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }

# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
icecatview-history-site-localhost = (local files)

##

icecatview-show-all-history = Show all history

## Message displayed in IceCat View when the user has no history data

icecatview-history-empty-header = Get back to where you’ve been
icecatview-history-empty-description = As you browse, the pages you visit will be listed here.
icecatview-history-empty-description-two = Protecting your privacy is at the heart of what we do. It’s why you can control the activity { -brand-short-name } remembers, in your <a data-l10n-name="history-settings-url">history settings</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
icecatview-choose-browser-button = Choose browser
  .title = Choose browser

## Message displayed in IceCat View when the user has chosen to never remember History

icecatview-dont-remember-history-empty-header-2 = You’re in control of what { -brand-short-name } remembers
icecatview-dont-remember-history-empty-description-one = Right now, { -brand-short-name } does not remember your browsing activity. To change that, <a data-l10n-name="history-settings-url-two">update your history settings</a>.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in IceCat View
icecatview-import-history-close-button =
  .aria-label = Close
  .title = Close

## Text displayed in a dismissable banner to import bookmarks/history from another browser

icecatview-import-history-header = Import history from another browser
icecatview-import-history-description = Make { -brand-short-name } your go-to browser. Import browsing history, bookmarks, and more.

## Message displayed in IceCat View when the user has no recently closed tabs data

icecatview-recentlyclosed-empty-header = Closed a tab too soon?
icecatview-recentlyclosed-empty-description = Here you’ll find the tabs you recently closed, so you can reopen any of them quickly.
icecatview-recentlyclosed-empty-description-two = To find tabs from longer ago, view your <a data-l10n-name="history-url">browsing history</a>.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

icecatview-syncedtabs-device-notabs = No tabs open on this device

icecatview-syncedtabs-connect-another-device = Connect another device

icecatview-pinned-tabs =
  .title = Pinned Tabs

icecatview-tabs =
  .title = Tabs

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

icecatview-opentabs-pinned-tab =
  .title = Switch to { $tabTitle }

# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
icecatview-opentabs-bookmarked-pinned-tab =
  .title = Switch to (Bookmarked) { $tabTitle }

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
icecatview-opentabs-bookmarked-tab =
  .title = (Bookmarked) { $url }
