# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Callout dialog primary button to advance to next screen
callout-primary-advance-button-label = Next

# Callout dialog primary button to complete the feature tour
callout-primary-complete-button-label = Got it!

## Firefox View feature tour strings

# "Tab pickup" refers to the section in Firefox View that displays open
# tabs from other devices
callout-firefox-view-tab-pickup-title = Hop between devices with tab pickup

callout-firefox-view-tab-pickup-subtitle = Quickly grab open tabs from your phone and open them here for maximum flow.

callout-firefox-view-recently-closed-title = Get back your closed tabs in a snap

callout-firefox-view-recently-closed-subtitle = All your closed tabs will magically show up here. Never worry about accidentally closing a site again.

callout-firefox-view-colorways-title = Add a splash of color

# "Shade" refer to different color options in each colorway.
callout-firefox-view-colorways-subtitle = Choose the shade that speaks to you with colorways. Only in { -brand-product-name }.

callout-firefox-view-colorways-reminder-title = Explore our latest colorways

# “Shades” refers to the different color options in each colorways
callout-firefox-view-colorways-reminder-subtitle = Color your browser with these iconic shades, inspired by independent voices. Only in { -brand-product-name }.

## Continuous Onboarding - Firefox View: Tab pick up

# “Boost your browsing” refers to the added benefit the user receives from having
# access to the same browsing experience when moving from one browser to another.
# Alternative: ”Improve your browsing experience with tab pickup”
continuous-onboarding-firefox-view-tab-pickup-title = Boost your browsing with tab pickup

continuous-onboarding-firefox-view-tab-pickup-subtitle = Access your open tabs from any device. Plus sync your bookmarks, passwords, and more.

continuous-onboarding-firefox-view-tab-pickup-primary-button-label = Get started

## PDF.js Feature Tour Strings

callout-pdfjs-edit-title = Edit PDFs with our new text tool
callout-pdfjs-edit-body-a = Fill out forms, add comments, or take notes directly in { -brand-short-name }.
callout-pdfjs-edit-body-b = Skip the search for free online editors. Fill out forms, add comments, or take notes directly in { -brand-short-name }.
callout-pdfjs-edit-button = Next

callout-pdfjs-draw-title = Sign documents with our new draw tool
# “Mark up” refers to the process of “annotating” or adding free hand text or diagramming to the document.
callout-pdfjs-draw-body-a = Mark up PDFs, then save your changes.
# “Mark up” refers to the process of “annotating” or adding free hand text or diagramming to the document.
callout-pdfjs-draw-body-b = No more printing and scanning. Mark up PDFs, then save your changes.
callout-pdfjs-draw-button = Got it!

## Firefox View Discoverability Strings

fx-view-discoverability-title = Didn’t mean to close that tab?
fx-view-discoverability-subtitle = Find and reopen it quickly here. We keep a history of your recently closed tabs for you.
fx-view-discoverability-primary-button-label = Open { -firefoxview-brand-name }
fx-view-discoverability-secondary-button-label = Dismiss

## Sidebar Strings

sidebar-button-callout-title = Show tab titles in the sidebar
sidebar-button-callout-subtitle = Use the sidebar button to expand the sidebar, so you can see tab titles.
sidebar-button-callout-vertical-tabs = To show your tabs, select the sidebar button in the toolbar.

## Sidebar Vertical Tabs Strings

vertical-tabs-callout-1-title = Overwhelmed by too many tabs?
vertical-tabs-callout-1-subtitle = Try our new vertical tabs layout to quickly scan your list of tabs. Early testers report this layout helps them feel more organized. Switch anytime.
vertical-tabs-callout-1-cta-button = Try vertical tabs
vertical-tabs-callout-2-cta-button = Try now
vertical-tabs-callout-2-title = Keep a lot of tabs open? Try vertical tabs.
vertical-tabs-callout-2-subtitle = This layout makes it easy to quickly scan your list of tabs. Plus, you can adjust the width to see more or less of your tab titles.

## Sidebar Vertical Tabs Pinning Strings

sidebar-pins-callout-title = Losing track of your important tabs?
sidebar-pins-callout-subtitle = Try pinning them, which keeps them at the top of your list of tabs. Right-click on a tab you want to pin, then choose Pin Tab.
sidebar-pins-callout-cta-button = Pin tab

## Sidebar Onboarding Strings

sidebar-customization-callout-1-title = Sidebar: your spot for tools and tabs
sidebar-customization-callout-1-subtitle = The { -brand-product-name } sidebar gives you quick access to your browsing history, tabs from other devices, and an AI chatbot — all without leaving your main view.
sidebar-customization-callout-callout-button = Customize sidebar
sidebar-customization-callout-dismiss-button = Hide sidebar
sidebar-customization-callout-2-title = Make the { -brand-product-name } sidebar your own
sidebar-customization-callout-2-subtitle = Add and remove tools. Place your tabs in the sidebar. Give an AI chatbot a try. How you customize your sidebar is up to you.

## Sidebar Callout Survey Strings

sidebar-callout-survey-title = Help improve { -brand-short-name }
sidebar-callout-survey-satisfaction-question = How satisfied are you with the sidebar experience in { -brand-short-name }?
sidebar-callout-survey-privacy-notice-link = Privacy Notice
sidebar-callout-survey-very-satisfied = Very satisfied
sidebar-callout-survey-satisfied = Satisfied
sidebar-callout-survey-neutral = Neutral
sidebar-callout-survey-dissatisfied-2 = Dissatisfied
sidebar-callout-survey-very-dissatisfied-2 = Very dissatisfied
sidebar-callout-survey-dont-use-it = I don’t use it
sidebar-callout-survey-productive-question =
    To what extent do you agree or disagree with this statement:<br/>
    “The { -brand-short-name } sidebar helps me be more productive”?
sidebar-callout-survey-strongly-agree = Strongly agree
sidebar-callout-survey-agree = Agree
sidebar-callout-survey-disagree = Disagree
sidebar-callout-survey-strongly-disagree = Strongly disagree
sidebar-callout-survey-features-question = The following are potential sidebar features. Which would improve your productivity in { -brand-short-name } the most?
sidebar-callout-survey-split-view = View any two websites at once, in a side-by-side split view
sidebar-callout-survey-keep-website-open = Keep a website, like email or calendar, open in the sidebar as you browse
sidebar-callout-survey-saved-websites-2 = Quick access to your bookmarks
sidebar-callout-survey-none-of-above = None of the above
sidebar-callout-survey-submit = Submit
sidebar-callout-survey-thank-you = Thank you for your feedback!

# Sidebar GenAI Survey Strings

sidebar-genai-survey-satisfaction-question = How satisfied are you with having access to an AI chatbot in the sidebar?
sidebar-genai-survey-productive-question =
    To what extent do you agree or disagree with this statement:<br/>
    “The AI chatbot in the sidebar helps me be more productive”?

# Unified Search Button callout strings

unified-search-callout-title = Switch between search engines
unified-search-callout-subtitle = Choose what works best for your specific search.
unified-search-callout-primary-label = Next
unified-search-callout-secondary-label = Dismiss

unified-search-engines-callout-title = Search with a shortcut
unified-search-engines-callout-subtitle = Type “@” followed by a keyword to search your history, bookmarks, tabs, or with another search engine.
unified-search-engines-callout-primary-label = Got it

actions-callout-title = Complete common tasks or access basic settings
# The user can type "print" and "clear" and a button will appear in the
# search bar (e.g. Print page) the user can click to initiate the action.
# These example text inputs correlate to the the following strings
# (either matching the whole string, or the first word of the string).
# "print" - quickactions-cmd-print
# "clear" - quickactions-cmd-clearrecenthistory
# When localizing, ensure the translations match to ensure the action button appears as expected.
actions-callout-subtitle = Try typing an action like “print” to print a page, or “clear” to clear your history.

## Split Dismiss Button Labels

# Accessibility label for dropdown menu button
split-dismiss-button-default-label =
    .title = More options
# Blocks the message from showing again
split-dismiss-button-dont-show-option =
    .label = Don’t show this recommendation again
# Dismisses message and reduces frequency of message
split-dismiss-button-show-fewer-option =
    .label = Show fewer recommendations
# Opens about:preferences#general-cfrfeatures
split-dismiss-button-manage-settings-option =
    .label = Manage settings

## Login Status Advisory Callout (points to the account icon)

# The 'account icon' is the toolbar button with a 'profile' icon of a human
# head/shoulders. It's for dealing with your Mozilla account. When hovering the
# icon, the tooltip says 'Account'.
login-status-advisory-title = You’re signed out. Click the account icon to sign in.

## Bookmarks toolbar callout strings

bookmarks-toolbar-callout-1-title = Add this site to your bookmarks toolbar?
bookmarks-toolbar-callout-1-subtitle = Your bookmark will be saved just below the address bar for quick access.
bookmarks-toolbar-callout-1-primary-button-label = Add bookmark
bookmarks-toolbar-callout-1-secondary-button-label = No Thanks
# Visible if user adds a bookmark in callout 1, bookmarks toolbar is set to always show when this message renders
bookmarks-toolbar-callout-2a-title = Easily add more bookmarks
bookmarks-toolbar-callout-2a-subtitle = You can drag and drop tabs here to keep more of your favorite sites within reach.
bookmarks-toolbar-callout-2a-primary-button-label = Got it
# Reverts the bookmarks toolbar to the default setting
bookmarks-toolbar-callout-2a-secondary-button-label = Hide Toolbar
# Visible if user declines to add a bookmark in callout 1, bookmarks toolbar is set to always show when this message renders
bookmarks-toolbar-callout-2b-title = Keep your bookmarks toolbar open?
bookmarks-toolbar-callout-2b-subtitle = You can add other sites you visit more often. Simply drag and drop tabs here to keep favorite websites within reach.
bookmarks-toolbar-callout-2b-primary-button-label = Keep open
# Reverts the bookmarks toolbar to the default setting
bookmarks-toolbar-callout-2b-secondary-button-label = No thanks

## Perplexity callout strings

perplexity-callout-theme-1-title = Need the right answer, right away?
perplexity-callout-theme-2-title = Try Perplexity: a new way to search

perplexity-callout-theme-1-subtitle-1 = Try Perplexity. Choose it from the search button when you want complete answers, sources included.
perplexity-callout-theme-1-subtitle-2 = Ask questions. Get complete, well-cited answers. To try Perplexity, choose it from the search button.

perplexity-callout-theme-2-subtitle-1 = Ask Perplexity. You’ll get complete answers, sources included.
perplexity-callout-theme-2-subtitle-2 = Ask questions. Get complete, well-cited answers.

perplexity-callout-primary-label = Ask Perplexity
perplexity-callout-secondary-label-1 = Dismiss
perplexity-callout-secondary-label-2 = Got it
